(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26004,        895]*)
(*NotebookOutlinePosition[     26935,        926]*)
(*  CellTagsIndexPosition[     26891,        922]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Formal Series Solution\n",
  StyleBox["Example 8.15",
    FontSize->14]
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Modified 4/12/98 to be compatible with V 3.0 C. C. Ross
Modified 4/9/2000 to be compatible with V4.0 C. C. Ross
Minor modification to Sum (HoldAll) 4/9/2001 C. C. Ross\
\>", "Text",
  FontSize->10],

Cell[TextData[{
  "This notebook takes advantage of the fact that Sum does not evaluate when \
its terms are unknown. We can therefore perform manipulations on the \
unevaluated arguments. These manipulations parallel those you would perform \
in order to find a series solution manually.\n\nThe ",
  StyleBox["Yellow Boxed",
    FontWeight->"Bold"],
  " cells require special manual attention. ",
  StyleBox["These are places where you can direct the progress of the \
solution",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ". \n\n",
  StyleBox["Use Shift-Enter to select the next executable cell, and \
Shift-Enter again to execute it.",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Differential Operator & Assumed solution, y[x]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Execute each of the following cells in order. You will have to decide on \
the form of the solution. When Log series are necessary, you can decide on \
the highest power after trying a simple power series solution. Count the \
linearly independent power series solutions that you get. Then decide whether \
or not Log series are needed. \n",
  StyleBox["When asked to evaluate the initialization cells, respond 'Yes'.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Operator and its standard form", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Define your differential operator",
    FontWeight->"Bold"],
  " in the boxed cell below. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(Op[x_, v_]\), "=", 
      RowBox[{
        RowBox[{"x", " ", 
          RowBox[{
            SuperscriptBox["v", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{\((x - 8)\), " ", 
          RowBox[{
            SuperscriptBox["v", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "-", \(5\ v[x]\)}]}]], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.97586, 1, 0.710002]],

Cell[BoxData[
    RowBox[{\(\(-5\)\ v[x]\), "+", 
      RowBox[{\((\(-8\) + x)\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"x", " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["For this notebook to work correctly",
    FontWeight->"Bold"],
  ", the result of executing the next cell MUST be \n             ",
  StyleBox["{ReadProtected}",
    FontFamily->"Courier"],
  ".\n If not, ",
  StyleBox["re-execute the first cell in the Implementation section below and \
check the next cell again",
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(FixSum\), "\[IndentingNewLine]", 
    \(Attributes[Sum]\)}], "Input"],

Cell[BoxData[
    \({ReadProtected}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The function to be substituted", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This function call generates the proper form for the function to be \
assumed. The symbols in ",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " are the names of the coefficients which are to appear in the assumed \
solution. The ",
  Cell[BoxData[
      \(i\^th\)]],
  " name in the list names the coefficients of a series having the form  \n\t\
\t",
  StyleBox["CoeffList[[i]][k] x^(k+r) + Log[x]^(i-1)",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". \n\n",
  StyleBox[
  "The length of the list in the third parameter determines how many \
Log-power terms occur",
    FontVariations->{"Underline"->True}],
  ". \n\n",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " containing a single entry denotes x^r times a simple power series. If \
r=0, x^r===1.\n\nSide-effects: ",
  StyleBox["CoefficientNames ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "is defined globally for subsequent use. The symbol \[Omega] is used \
instead of \[Infinity] as an upper limit because \[Infinity] introduces \
special problems which using \[Omega] avoids. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[y, r, t, a, b, c, d, e]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = MakeAssumedFunction[x, r, {a}]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[k]\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute y[x] into the operator Op[x, y]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[FormalSeriesResult]\), "\n", 
    \(FormalSeriesResult[x_] = ReleaseHold[Op[x, y]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k + r)\)\ \((k + 
                r)\)\ x\^\(\(-2\) + k + r\)\ a[k]\) + \((\(-8\) + 
            x)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((k + 
                r)\)\ x\^\(\(-1\) + k + r\)\ a[k]\) - 
      5\ \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[k]\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Manipulate the Formal Series"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Convert the form of each series or Log series so that zero can be imposed \
by the proper choice of the series coefficients. Remove the factor  x^r. Our \
goal is to force each component in  ",
  StyleBox["FormalPowerSeries ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "to be identically zero. This creates a recursion relation for each \
component. \n\nThe coefficients of the Log series in decreasing powers occur \
before the power series. The power series is always the last (or only) \
component."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalPowerSeries = \ MakeFormalPowerSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\[Sum]\+\(k = 0\)\%\[Omega]\(-8\)\ \((k + r)\)\ x\^\(\(-1\) + k\)\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k + r)\)\ \((k + 
                r)\)\ x\^\(\(-1\) + k\)\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\(-5\)\ x\^k\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\((k + r)\)\ x\^k\ a[
              k]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Determining Set"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Generate the determining set. Look in the recursion relation(s) for the \
properties that it predicts. If there are Log series present, the determining \
set describes the (homogeneous) recursion relation of the coefficients of the \
highest log power. In subsequent recursion relations, the correct form is \
predicted, except that the recursion relation is nonhomogeneous. Look for \
this later."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["DeterminingSet = MakeDeterminingSet", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-1\), 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The final series form"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Combine the series in each component into a single sum with some extra \
terms left over. The coefficient of the term of lowest degree in the first \
component, when set to zero, is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  ", from which the indices are obtained.\n\nNote that ",
  StyleBox["subMax",
    FontWeight->"Bold"],
  " and ",
  StyleBox["subMin",
    FontWeight->"Bold"],
  " are Global variables."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(finalSeries = MakeFinalSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(\(-8\)\ r\ a[0] + \((\(-1\) + r)\)\ r\ a[0]\)\/x + \[Sum]\+\(k = 0\)\
\%\[Omega] x\^k\ \((\((\(-5\) + k + r)\)\ a[
                    k] + \((\(-8\) + k + r)\)\ \((1 + k + r)\)\ a[
                    1 + k])\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Recursion Relation(s)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Here are the recursion relations for each of the components. The first \
relation determines the coefficients of the highest power Log series. Each \
subsequent relation determines the coefficients of a lower power Log series. \
The last (or only) relation determines the power series coefficients."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["RecursionRelation = MakeRecursionRelation", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{\((\(-5\) + k + r)\)\ a[k] + \((\(-8\) + k + r)\)\ \((1 + k + r)\)\ a[
                1 + k] == 0, k \[GreaterEqual] 0}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initial Equations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "These are the equations that are not explicitly generated by the recursion \
relation(s). The very first one is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["InitialEquations = MakeInitialEquations", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-9\)\ r\ a[0] + r\^2\ a[0] == 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Indices"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Solve the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  " to get the indices."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(IndicialEquation = Take[InitialEquations, {1}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-9\)\ r\ a[0] + r\^2\ a[0] == 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Manually make an adjustment to the left hand side below",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ", depending on the order of ",
  StyleBox["IndicialEquation",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as a polynomial in r. One simple way is to execute the cell once, and \
then adjust so the number of named indices ",
  StyleBox["{r1 ,r2, ...}",
    FontWeight->"Bold"],
  " matches the number of roots.\n\n",
  StyleBox["If the indicial equation",
    FontVariations->{"Underline"->True}],
  " is always ",
  StyleBox["True",
    FontWeight->"Bold"],
  " (as it may be for series centered on an ordinary point), set ",
  StyleBox["r1=0",
    FontWeight->"Bold"],
  " and do not execute the next cell. Then do not use r2."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = r /. Solve[IndicialEquation, r]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \({0, 9}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equate Coefficients to 0 (Using n=14)", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Choose the number of terms you want in this boxed cell:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(n = 14;\)\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[TextData[
"Now that we know the number of coefficients we need to determine, we can \
generate the equations that will be used to determine them and the list of \
unknowns in the required order (back to front)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(EquationList[r_] = 
        Join[InitialEquations, 
          Table[AllRecursionRelations[k, r], {k, subMax, n}]];\)\(\n\)
    \)\), "\n", 
    \(TheCoefficients = 
      Join @@ \(\((Table[#1[n - subMin - j], {j, 0, n - subMin}] &)\) /@ 
          Reverse[CoefficientNames]\)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[15], a[14], a[13], a[12], a[11], a[10], a[9], a[8], a[7], a[6], 
      a[5], a[4], a[3], a[2], a[1], a[0]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The first series solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Use the first index to generate (one or more) solutions. Here is where you \
have to be particularly observant. Often two indices will generate the same \
series. Watch carefully for this!  If, after using every index, you still are \
missing some solutions, go back and recalculate with more Log series terms. \
Do this by appending another symbol in the third component of the function \
that generates the assumed function y[x]. Eventually you will get a full \
complement of linearly independent solutions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = 
      MakeSeriesSolution[r1] + O[x]^\((n + 2)\) /. a[9] \[Rule] 0\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\), "-", \(5\/8\ a[0]\ x\), "+", \(5\/28\ a[0]\ x\^2\), 
        "-", \(5\/168\ a[0]\ x\^3\), "+", \(1\/336\ a[0]\ x\^4\), 
        "-", \(\(a[0]\ x\^5\)\/6720\), "+", 
        InterpretationBox[\(O[x]\^16\),
          SeriesData[ x, 0, {}, 0, 16, 1]]}],
      SeriesData[ x, 0, {
        a[ 0], 
        Times[ 
          Rational[ -5, 8], 
          a[ 0]], 
        Times[ 
          Rational[ 5, 28], 
          a[ 0]], 
        Times[ 
          Rational[ -5, 168], 
          a[ 0]], 
        Times[ 
          Rational[ 1, 336], 
          a[ 0]], 
        Times[ 
          Rational[ -1, 6720], 
          a[ 0]]}, 0, 16, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y1]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^15\),
      SeriesData[ x, 0, {}, 15, 15, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"A second series solution (when r2 != r1) - if needed."], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = 
      MakeSeriesSolution[r2] + O[x]^\((n + 2)\) /. 
        a[0] \[Rule] a[9]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[9]\ x\^9\), "-", \(2\/5\ a[9]\ x\^10\), 
        "+", \(1\/11\ a[9]\ x\^11\), "-", \(1\/66\ a[9]\ x\^12\), 
        "+", \(\(7\ a[9]\ x\^13\)\/3432\), "-", \(\(a[9]\ x\^14\)\/4290\), 
        "+", \(\(a[9]\ x\^15\)\/42900\), "+", 
        InterpretationBox[\(O[x]\^16\),
          SeriesData[ x, 0, {}, 9, 16, 1]]}],
      SeriesData[ x, 0, {
        a[ 9], 
        Times[ 
          Rational[ -2, 5], 
          a[ 9]], 
        Times[ 
          Rational[ 1, 11], 
          a[ 9]], 
        Times[ 
          Rational[ -1, 66], 
          a[ 9]], 
        Times[ 
          Rational[ 7, 3432], 
          a[ 9]], 
        Times[ 
          Rational[ -1, 4290], 
          a[ 9]], 
        Times[ 
          Rational[ 1, 42900], 
          a[ 9]]}, 9, 16, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check second solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^15\),
      SeriesData[ x, 0, {}, 15, 15, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation (Initialization Cells) ", "Section",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell["\<\
Unprotect[Sum];
FixSum:=ClearAttributes[Sum,HoldAll];\
\>", "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Define Standard form of operator", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
SetAttributes[StandardOperatorForm, HoldAll]; 
StandardOperatorForm[(L_)[x_, v_]] := 
  L[x, v] /. Derivative[p_][v][x] :> HoldForm[D[v[x], {x, p}]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Assumed Function", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[MakeAssumedFunction]; 
MakeAssumedFunction[x_, r1_:0, CoeffList_List] := 
  Module[{n = Length[CoeffList],r = r1, i,s}, 
  \tOff[Part::pspec];Off[General::spell1];
   CoefficientNames = CoeffList; 
   s=Sum[(CoeffList[[i]][k])*x^(k+r)*Log[x]^(i-1), \t
   \t\t{i,1,Max[n, 1]}];
   \tOn[Part::pspec];On[General::spell1];
   If[TrueQ[Head[s]==Plus],Map[Sum[#,{k,0,\[Omega]} ]&,s],
   \t\tSum[s,{k,0,\[Omega]}]]
   ]
   \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Function which Makes Series Solutions", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[MakeSeriesSolution]; 
MakeSeriesSolution[r_] := 
  Module[{rootRules}, Off[Solve::svars];
  rootRules = 
     Solve[Flatten[EquationList[r]],
     \tTheCoefficients, Sort -> False]; 
  On[Solve::svars];
  MakeAssumedFunction[x, r, CoefficientNames]/.\[Omega]\[Rule]n-subMin \
/.rootRules[[1]]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MakeFormalPowerSeries := 
      Module[{LogStep1, LogStep2, LogStep3, TheLogParts, step0, step1}, 
        LogStep1 = FormalSeriesResult[x] //. RemoveLogPowers; 
        LogStep2 = LogStep1 //. RemoveSimpleLog; 
        LogStep3 = LogStep2 //. ToIndividualSums; 
        TheLogParts = Reverse[CoefficientList[LogStep3, t]]; 
        step0 = TheLogParts /. RemoveFactor[x, r]; 
        step1 = step0 //. RemoveZeroTerms; 
        step1 //. IncorporateFactors]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeFinalSeries := 
      Module[{step3, step4, step5, step6, step7, step8}, 
        subMax = Max[DeterminingSet]; subMin = Min[DeterminingSet]; 
        step3 = FormalPowerSeries //. AdjustIndices; 
        step4 = step3 /. EqualizeInitialIndices[subMax]; 
        step5 = step4 //. CombineSeries; 
        step6 = step5 /. CollectInitialTerms[x]; 
        step7 = step6 //. CollectSeriesTerms; 
        step8 = step7 //. CollectCoefficientTerms; 
        step8 //. FactorCoefficientTerms]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeDeterminingSet\  := \ \n\ \ Module[{}, \ 
        StepsToList\  = \ \n\ \ \ \ \ Flatten[
            FormalPowerSeries\  //. \ \n\ \ \ \ \ \ \ Plus[
                  Sum[c_, \ {k_, \ 
                        s_, \ \[Omega]}]\  + \ \((e_)\)]\  :> \ \n\ \ \ \ \ \ \
\ \ {Sum[c, \ {k, \ s, \ \[Omega]}], \ e}]; \ \n\ \ \ \ Union[
          StepsToList\  //. \ \n\ \ \ \ \ \ Sum[\((a_. )\)*
                  x^\((\((k_)\)\  + \ \((p_. )\))\), \ {k, \ 
                  s_, \ \[Omega]}]\  :> \ p]\n]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeRecursionRelation\  := \ \n\ \ finalSeries\  /. \ \n\ \ \ \((p_)\)\ \
 + \ Sum[\((c_)\)*\((x_)\)^\((k_)\), \ {k_, \ 
                s_, \ \[Omega]}]\  :> \ \n\ \ \ \ {c\  == \ 0, \ 
            k\  >= \ s}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeInitialEquations\  := \ \n\ \ Module[{InitialTerms}, \ \n\ \ \ \
AllRecursionRelations[k_, \ 
            r_]\  = \ \n\ \ \ \ \ \(Transpose[
              RecursionRelation]\)[\([1]\)]; \ \n\ \ \ \ InitialTerms\  = \ \n\
\ \ \ \ \ Expand[\((finalSeries\  /. \ \n\ \ \ \ \ \ \ \ \ \((p_)\)\  + \ 
                      Sum[\((c_)\)*\((x_)\)^\((k_)\), \ \n\ \ \ \ \ \ \ \ \ \ \
\ \ {k_, \ s_, \ \[Omega]}]\  :> \ p)\)/
              x^subMin]; \ \n\ \ \ \ \((#1\  == \ 
                0\  &\ )\)\  /@ \ \n\ \ \ \ \ Flatten[
            CoefficientList[InitialTerms, \ x]]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Transformation Rules", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(AdjustIndices\  = \ \n\ \ \ Sum[\((c_)\)*\((x_)\)^\((\((k_)\)\  + \ \
\((q_)\))\), \ {k_, \ 
              s_, \ \[Omega]}]\  :> \ \n\ \ \ \ Sum[\((c\  /. \ 
                  k\  :> \ k\  - \ q)\)*x^k, \ {k, \ 
              s\  + \ q, \ \[Omega]}];\)\(\ \)\)\)], "Input",
  InitializationCell->True],

Cell["\<\
RemoveLogPowers = 
   (a_.)*Sum[(p1_)*Log[x_]^(q_) + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t^q*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveSimpleLog = 
   (a_.)*Sum[(p1_)*Log[x_] + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
ToIndividualSums = 
   (a_.)*Sum[(p1_) + (p2_), {k_, s_, \[Omega]}] :> 
    a*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell["RemoveFactor[x_, r_] = x^((p_) + r) :> x^p; ", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveZeroTerms = 
   Sum[(c_)*(x_)^(p_), {k_, a_, \[Omega]}] :> 
    Sum[c*x^p, {k, a + 1, \[Omega]}] /; (c /. k -> a) == 0; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
IncorporateFactors = 
   ((a_.) + (b_))*Sum[c_, {k_, s_, \[Omega]}] :> 
    Sum[a*c, {k, s, \[Omega]}] + Sum[b*c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Clear[EqualizeInitialIndices]
EqualizeInitialIndices[subMax_] := 
  Sum[c_, {k_, s_, \[Omega]}] :> 
   Sum[c, {k, s, subMax - 1}] + Sum[c, {k, subMax, \[Omega]}] /; s < subMax\
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CombineSeries = 
   Sum[c_, {k_, s_, \[Omega]}] + Sum[d_, {k_, s_, \[Omega]}] :> 
    Sum[c + d, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectInitialTerms[x_] = 
   (p_) + Sum[c_, {k_, s_, \[Omega]}] :> 
    Collect[p, x] + Sum[c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectSeriesTerms = 
   Sum[(x_)^(k_)*(c1_.) + (x_)^(k_)*(d1_.) + (e1_.), {k_, s_, \[Omega]}] :> 
    Sum[x^k*(c1 + d1) + e1, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectCoefficientTerms = 
   Sum[(x_)^(k_)*((c1_.)*(c_)[p_] + (d1_.)*(c_)[p_] + (e1_.)), 
     {k_, s_, \[Omega]}] :> Sum[x^k*((c1 + d1)*c[p] + e1), {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
FactorCoefficientTerms = 
   Sum[((c1_)*(c_)[p_] + (c2_)*(c_)[q_] + (c3_.))*x^k, {k_, s_, \[Omega]}] :> \

    Sum[(Factor[c1]*c[p] + Factor[c2]*c[q] + c3)*x^k, {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{591, 660},
WindowMargins->{{23, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 154, 6, 83, "Subtitle",
  Evaluatable->False],
Cell[1933, 61, 207, 5, 59, "Text"],
Cell[2143, 68, 757, 18, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2925, 90, 117, 2, 56, "Section",
  Evaluatable->False],
Cell[3045, 94, 556, 11, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3626, 109, 104, 2, 46, "Subsection",
  Evaluatable->False],
Cell[3733, 113, 179, 6, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3937, 123, 512, 14, 43, "Input"],
Cell[4452, 139, 371, 9, 27, "Output"]
}, Closed]],
Cell[4838, 151, 403, 11, 68, "Text"],

Cell[CellGroupData[{
Cell[5266, 166, 90, 2, 43, "Input"],
Cell[5359, 170, 49, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5457, 177, 100, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5560, 181, 1153, 32, 212, "Text",
  Evaluatable->False],
Cell[6716, 215, 88, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[6829, 221, 163, 4, 43, "Input"],
Cell[6995, 227, 80, 1, 50, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7136, 235, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7270, 241, 149, 3, 43, "Input"],
Cell[7422, 246, 332, 5, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7803, 257, 105, 2, 36, "Section",
  Evaluatable->False],
Cell[7911, 261, 593, 13, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8529, 278, 102, 2, 27, "Input"],
Cell[8634, 282, 373, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9056, 294, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[9151, 298, 472, 8, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9648, 310, 78, 1, 27, "Input"],
Cell[9729, 313, 45, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9823, 320, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[9924, 324, 512, 15, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10461, 343, 88, 2, 27, "Input"],
Cell[10552, 347, 249, 4, 85, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10850, 357, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[10955, 361, 376, 7, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11356, 372, 84, 1, 27, "Input"],
Cell[11443, 375, 157, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11649, 383, 94, 2, 36, "Section",
  Evaluatable->False],
Cell[11746, 387, 260, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12031, 399, 82, 1, 27, "Input"],
Cell[12116, 402, 69, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12234, 409, 88, 2, 36, "Section",
  Evaluatable->False],
Cell[12325, 413, 173, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12523, 424, 105, 2, 27, "Input"],
Cell[12631, 428, 69, 1, 29, "Output"]
}, Closed]],
Cell[12715, 432, 848, 24, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13588, 460, 167, 4, 43, "Input"],
Cell[13758, 466, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13847, 473, 104, 2, 36, "Section",
  Evaluatable->False],
Cell[13954, 477, 130, 3, 32, "Text",
  Evaluatable->False],
Cell[14087, 482, 136, 4, 43, "Input"],
Cell[14226, 488, 274, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14525, 497, 341, 8, 107, "Input"],
Cell[14869, 507, 143, 2, 43, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15061, 515, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[15166, 519, 585, 9, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15776, 532, 136, 4, 27, "Input"],
Cell[15915, 538, 702, 23, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16654, 566, 75, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16754, 572, 76, 2, 27, "Input"],
Cell[16833, 576, 101, 2, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16995, 585, 131, 3, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17151, 592, 146, 4, 27, "Input"],
Cell[17300, 598, 829, 27, 79, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[18166, 630, 101, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18292, 636, 76, 2, 27, "Input"],
Cell[18371, 640, 101, 2, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18533, 649, 165, 4, 36, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[18701, 655, 106, 4, 42, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[18832, 663, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[18937, 667, 227, 6, 72, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[19201, 678, 93, 2, 30, "Subsection",
  Evaluatable->False],
Cell[19297, 682, 501, 15, 207, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[19835, 702, 114, 2, 30, "Subsection",
  Evaluatable->False],
Cell[19952, 706, 378, 12, 147, "Input",
  InitializationCell->True],
Cell[20333, 720, 519, 10, 203, "Input",
  InitializationCell->True],
Cell[20855, 732, 552, 11, 187, "Input",
  InitializationCell->True],
Cell[21410, 745, 562, 10, 139, "Input",
  InitializationCell->True],
Cell[21975, 757, 271, 5, 75, "Input",
  InitializationCell->True],
Cell[22249, 764, 636, 11, 171, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[22922, 780, 90, 2, 30, "Subsection",
  Evaluatable->False],
Cell[23015, 784, 325, 6, 59, "Input",
  InitializationCell->True],
Cell[23343, 792, 233, 7, 87, "Input",
  InitializationCell->True],
Cell[23579, 801, 226, 7, 72, "Input",
  InitializationCell->True],
Cell[23808, 810, 216, 7, 57, "Input",
  InitializationCell->True],
Cell[24027, 819, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[24145, 823, 205, 6, 72, "Input",
  InitializationCell->True],
Cell[24353, 831, 212, 6, 57, "Input",
  InitializationCell->True],
Cell[24568, 839, 256, 8, 87, "Input",
  InitializationCell->True],
Cell[24827, 849, 195, 6, 57, "Input",
  InitializationCell->True],
Cell[25025, 857, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[25222, 865, 225, 6, 72, "Input",
  InitializationCell->True],
Cell[25450, 873, 250, 7, 87, "Input",
  InitializationCell->True],
Cell[25703, 882, 261, 8, 87, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

, 87, "Input",
  InitializationCell->True],
Cell[25312, 863, 195, 6, 57, "Input",
  InitializationCell->True],
Cell[25510, 871, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[25707, 879, 225, 6, 72, "Input",
  InitializationCell->True],
Cell[25935, 887, 250, 7, 87, "Input",
  InitializationCell->True],
Cell[26188, 896, 261, 8, 87, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

